package org.lwapp.commons.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.FileUtils;
import org.lwapp.commons.io.IoTools;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfigurationParser {

    private static final String APPLICATION_PROPERTIES_FILE = "application.properties.yml";

    public static <T> T getConfiguration(final Class<T> clazz) {
        return getConfiguration(clazz, APPLICATION_PROPERTIES_FILE, true);
    }

    public static <T> T getConfiguration(final Class<T> clazz, final boolean skipMissingProperties) {
        return getConfiguration(clazz, APPLICATION_PROPERTIES_FILE, skipMissingProperties);
    }

    public static <T> T getConfiguration(final Class<T> clazz, final String ymlFile) {
        return getConfiguration(clazz, ymlFile, true);
    }

    public static <T> T getConfiguration(final Class<T> clazz, final String ymlFile, final boolean skipMissingProperties) {
        try {
            return getConfiguration(clazz, new File(IoTools.getResourceUrl(ymlFile).toURI()), skipMissingProperties);
        } catch (final Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getConfiguration(final Class<T> clazz, final File ymlFile, final boolean skipMissingProperties) {
        final Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(skipMissingProperties);
        final Yaml yaml = new Yaml(new Constructor(clazz), representer);
        try (InputStream in = FileUtils.openInputStream(ymlFile)) {
            return yaml.loadAs(in, clazz);
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseYamlString(final Class<T> clazz, final String ymlString, final boolean skipMissingProperties) {
        final Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(skipMissingProperties);
        final Yaml yaml = new Yaml(new Constructor(clazz), representer);
        return yaml.loadAs(ymlString, clazz);

    }

    public static <T> String marshal(final T object) throws IOException {
        final Yaml yaml = new Yaml();
        return yaml.dump(object);
    }
}
