package org.lwapp.commons.exception;

/**
 * Thrown to indicate a requested operation or access to a requested resource is
 * not allowed.
 *
 * @since 0.1
 */
public class UnauthorizedException extends RuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new UnauthorizedException.
	 */
	public UnauthorizedException() {
		super();
	}

	/**
	 * Constructs a new UnauthorizedException.
	 *
	 * @param message
	 *            the reason for the exception
	 */
	public UnauthorizedException(final String message) {
		super(message);
	}

	/**
	 * Constructs a new UnauthorizedException.
	 *
	 * @param cause
	 *            the underlying Throwable that caused this exception to be
	 *            thrown.
	 */
	public UnauthorizedException(final Throwable cause) {
		super(cause);
	}

	/**
	 * Constructs a new UnauthorizedException.
	 *
	 * @param message
	 *            the reason for the exception
	 * @param cause
	 *            the underlying Throwable that caused this exception to be
	 *            thrown.
	 */
	public UnauthorizedException(final String message, final Throwable cause) {
		super(message, cause);
	}
}
