package org.lwapp.commons.utils;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;

import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ClassUtils {

    public static <T> Set<Class<? extends T>> findSubClasses(final Class<T> superClass) {
        final ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setUrls(ClasspathHelper.forJavaClassPath());
        final Reflections reflections = new Reflections(cb);

        return Collections.unmodifiableSet(reflections.getSubTypesOf(superClass));
    }

    public static Set<Class<?>> getAllClassesWithAnnotation(final Class<? extends Annotation> annotation) {
        final ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setUrls(ClasspathHelper.forJavaClassPath());
        final Reflections reflections = new Reflections(cb);
        return Collections.unmodifiableSet(reflections.getTypesAnnotatedWith(annotation, true));
    }

}
