package org.lwapp.commons.utils;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbUtil {

    private static final Logger log = LoggerFactory.getLogger(JaxbUtil.class);
    private static final JAXBContext jaxbContext;

    static {
        try {
            jaxbContext = JAXBContext.newInstance(ClassUtils.getAllClassesWithAnnotation(XmlRootElement.class).toArray(new Class[] {}));
        } catch (final Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String marshalMessage(final T object, final Class<T> jaxbClass) throws JAXBException {
        final StringWriter sw = new StringWriter();
        final Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty(Marshaller.JAXB_ENCODING, "UTF-8");
        marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
        final QName name = new QName(object.getClass().getSimpleName());
        final JAXBElement<T> element = new JAXBElement<T>(name, jaxbClass, object);
        marshaller.marshal(element, sw);
        return sw.toString();
    }

    public static <JaxbClass> JaxbClass unMarshalMessage(final String xml, final Class<JaxbClass> jaxbClass) throws JAXBException {
        log.trace("Unmarshal message : \n\n{}", xml);
        final StringReader sr = new StringReader(xml);
        final Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        final JAXBElement<JaxbClass> jaxbElement = unmarshaller.unmarshal(new StreamSource(sr), jaxbClass);
        return jaxbElement.getValue();

    }
}
