/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.cli;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lwapp.commons.cli.CliClientHandler;
import org.lwapp.commons.cli.CliSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CliServerFactory.class);
    static final ExecutorService iExecutor = Executors.newCachedThreadPool();

    public static void startCli(int port, CliClientHandler cliHandler) throws IOException {
        CliServer server = new CliServer(new ServerSocket(port), cliHandler);
        iExecutor.submit(server);
    }

    private static class CliServer
    implements Runnable,
    Closeable {
        private final ServerSocket serverSocket;
        private final CliClientHandler clientHandler;

        public CliServer(ServerSocket ss, CliClientHandler cch) {
            this.serverSocket = ss;
            this.clientHandler = cch;
        }

        @Override
        public void run() {
            LOG.info("Cli Server is starting.");
            while (!this.serverSocket.isClosed()) {
                LOG.info("Ready to accept cli clients to connect. Only clients from '127.0.0.1' are allowed.");
                try {
                    Socket socket = this.serverSocket.accept();
                    String inetHostAddress = socket.getInetAddress().getHostAddress();
                    if (inetHostAddress.equals("127.0.0.1")) {
                        iExecutor.submit(new CliSocketHandler(this.clientHandler, socket));
                        continue;
                    }
                    LOG.warn("Only clients from '127.0.0.1' are allowed.", (Object)inetHostAddress);
                    socket.close();
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void close() {
            try {
                if (!this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to close socket. Try TERM KILL", (Throwable)e);
            }
        }
    }
}

