/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.cli;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;
import org.lwapp.commons.cli.Ascii;
import org.lwapp.commons.cli.Cli;
import org.lwapp.commons.cli.CliClientHandler;
import org.lwapp.commons.cli.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetClientHandler
implements CliClientHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TelnetClientHandler.class);
    private final String commandPrompt;
    private final Cli cli;

    public TelnetClientHandler(String prompt, Cli cli) {
        this.commandPrompt = prompt;
        this.cli = cli;
    }

    @Override
    public void handle(InputStream in, PrintStream out) throws Exception {
        PrintWriter pw = new PrintWriter(out);
        out.println("Waiting for commands. Type '?' to get list of all available commands.");
        out.print(this.commandPrompt);
        StringBuilder sb = new StringBuilder();
        while (true) {
            int data;
            if ((data = in.read()) == -1 || Ascii.CTRL_D.eq(data)) {
                out.println("");
                break;
            }
            if (Ascii.LF.eq(data)) {
                String line = sb.toString().trim();
                sb = new StringBuilder();
                LOG.info("Command line: '{}'", (Object)line);
                if ("exit".equals(line)) break;
                if (StringUtils.isNotBlank((String)line)) {
                    this.cli.process(new Terminal(out, in), line);
                    pw.println();
                    pw.flush();
                }
                out.println();
                out.print(this.commandPrompt + "$");
            }
            if (Ascii.isPrintable(data)) {
                sb.append((char)data);
            }
            if (Ascii.BS.eq(data)) {
                boolean isWinXP = System.getProperty("os.name", "").equals("Windows XP");
                if (isWinXP) {
                    out.write(32);
                }
                if (sb.length() <= 0) continue;
                sb.setLength(sb.length() - 1);
                out.write(Ascii.BS.intValue());
                continue;
            }
            if (!Ascii.ESC.eq(data)) continue;
            out.print("^[");
        }
        out.println("Bye.");
    }
}

