/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.cli;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class Terminal {
    private final BufferedReader in;
    private final PrintStream out;

    public Terminal(PrintStream ps, InputStream inputStream) {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.out = ps;
    }

    public Terminal() {
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.out = System.out;
    }

    public String readString(String prompt) {
        this.print(prompt);
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readString(String prompt, String defaultValue) {
        Validate.notBlank((CharSequence)defaultValue, (String)"Default value cannot be blank.", (Object[])new Object[0]);
        this.print(prompt + "[" + defaultValue + "]");
        try {
            String readLine = this.in.readLine();
            return StringUtils.isNotBlank((CharSequence)readLine) ? readLine : defaultValue;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void println(String prompt) {
        this.out.println(prompt);
    }

    public void print(String prompt) {
        this.out.print(prompt);
    }

    public String readPassword(String prompt) {
        Console console = System.console();
        if (console == null) {
            return this.readString(prompt);
        }
        return new String(console.readPassword(prompt, new Object[0]));
    }
}

