/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.lwapp.commons.io.IoTools;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfigurationParser {
    private static final String APPLICATION_PROPERTIES_FILE = "application.properties.yml";

    public static <T> T getConfiguration(Class<T> clazz) {
        return YamlConfigurationParser.getConfiguration(clazz, APPLICATION_PROPERTIES_FILE, true);
    }

    public static <T> T getConfiguration(Class<T> clazz, boolean skipMissingProperties) {
        return YamlConfigurationParser.getConfiguration(clazz, APPLICATION_PROPERTIES_FILE, skipMissingProperties);
    }

    public static <T> T getConfiguration(Class<T> clazz, String ymlFile) {
        return YamlConfigurationParser.getConfiguration(clazz, ymlFile, true);
    }

    public static <T> T getConfiguration(Class<T> clazz, String ymlFile, boolean skipMissingProperties) {
        try {
            return YamlConfigurationParser.getConfiguration(clazz, new File(IoTools.getResourceUrl(ymlFile).toURI()), skipMissingProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getConfiguration(Class<T> clazz, File ymlFile, boolean skipMissingProperties) {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(skipMissingProperties);
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(clazz), representer);
        try (FileInputStream in = FileUtils.openInputStream((File)ymlFile);){
            Object object = yaml.loadAs((InputStream)in, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseYamlString(Class<T> clazz, String ymlString, boolean skipMissingProperties) {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(skipMissingProperties);
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(clazz), representer);
        return (T)yaml.loadAs(ymlString, clazz);
    }

    public static <T> String marshal(T object) throws IOException {
        Yaml yaml = new Yaml();
        return yaml.dump(object);
    }
}

