/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.utils;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.lwapp.commons.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbUtil {
    private static final Logger log = LoggerFactory.getLogger(JaxbUtil.class);
    private static final JAXBContext jaxbContext;

    public static <T> String marshalMessage(T object, Class<T> jaxbClass) throws JAXBException {
        StringWriter sw = new StringWriter();
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        QName name = new QName(object.getClass().getSimpleName());
        JAXBElement element = new JAXBElement(name, jaxbClass, object);
        marshaller.marshal((Object)element, (Writer)sw);
        return sw.toString();
    }

    public static <JaxbClass> JaxbClass unMarshalMessage(String xml, Class<JaxbClass> jaxbClass) throws JAXBException {
        log.trace("Unmarshal message : \n\n{}", (Object)xml);
        StringReader sr = new StringReader(xml);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Source)new StreamSource(sr), jaxbClass);
        return (JaxbClass)jaxbElement.getValue();
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])ClassUtils.getAllClassesWithAnnotation(XmlRootElement.class).toArray(new Class[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

