package org.lwapp.jms.common;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class JmsDestination {
    @NotNull
    private String url;

    private String queueName;
    private String topicName;

    public boolean isQueue() {
        return topicName == null;
    }

    public String getUrl() {
        return url;
    }

    public String getTopicName() {
        return topicName;
    }

    public String getQueueName() {
        return queueName;
    }

    public void setUrl(final String url) {
        this.url = url;
    }

    public void setQueueName(final String queueName) {
        this.queueName = queueName;
    }

    public void setTopicName(final String topicName) {
        this.topicName = topicName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public static class Builder {
        private String url;
        private String queueName;
        private String topicName;

        public Builder url(final String url) {
            this.url = url;
            return this;
        }

        public Builder queueName(final String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder topicName(final String topicName) {
            this.topicName = topicName;
            return this;
        }

        public JmsDestination build() {
            final JmsDestination jmsDestination = new JmsDestination();
            jmsDestination.url = url;
            jmsDestination.queueName = queueName;
            jmsDestination.topicName = topicName;
            return jmsDestination;
        }
    }
}
