package org.lwapp.jms.common;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;

public class JmsMessage implements Serializable {

	private static final long serialVersionUID = 1L;
	private String message;
	private String fingerPrint;
	private String logTraceId;

	public String getMessage() {
		return message;
	}

	public void setMessage(final String message) {
		this.message = message;
	}

	public String getFingerPrint() {
		return fingerPrint;
	}

	public void setFingerPrint(final String fingerPrint) {
		this.fingerPrint = fingerPrint;
	}

	public String getLogTraceId() {
		return logTraceId;
	}

	public void setLogTraceId(final String logTraceId) {
		this.logTraceId = logTraceId;
	}

	public static class Builder {
		private String message;
		private String fingerPrint;
		private String logTraceId;

		public Builder message(final String message) {
			this.message = message;
			return this;
		}

		public Builder fingerPrint(final String fingerPrint) {
			this.fingerPrint = fingerPrint;
			return this;
		}

		public Builder logTraceId(final String logTraceId) {
			this.logTraceId = logTraceId;
			return this;
		}

		public JmsMessage build() {
			final JmsMessage jmsMessage = new JmsMessage();
			jmsMessage.message = message;
			jmsMessage.fingerPrint = fingerPrint;
			jmsMessage.logTraceId = StringUtils.defaultIfBlank(logTraceId, StringUtils.defaultString(MDC.get("logTraceId"), String.valueOf(System.nanoTime())));
			return jmsMessage;
		}
	}
}
