/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.jms.common;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;

public class JmsMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String message;
    private String fingerPrint;
    private String logTraceId;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public String getLogTraceId() {
        return this.logTraceId;
    }

    public void setLogTraceId(String logTraceId) {
        this.logTraceId = logTraceId;
    }

    public static class Builder {
        private String message;
        private String fingerPrint;
        private String logTraceId;

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder fingerPrint(String fingerPrint) {
            this.fingerPrint = fingerPrint;
            return this;
        }

        public Builder logTraceId(String logTraceId) {
            this.logTraceId = logTraceId;
            return this;
        }

        public JmsMessage build() {
            JmsMessage jmsMessage = new JmsMessage();
            jmsMessage.message = this.message;
            jmsMessage.fingerPrint = this.fingerPrint;
            jmsMessage.logTraceId = StringUtils.defaultIfBlank((String)this.logTraceId, (String)StringUtils.defaultString((String)MDC.get((String)"logTraceId"), (String)String.valueOf(System.nanoTime())));
            return jmsMessage;
        }
    }
}

