/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.jms.common.incoming;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.jms.Connection;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.lwapp.jms.common.JmsDestination;
import org.lwapp.jms.common.JmsMessage;
import org.lwapp.jms.utils.Generics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJmsQueuePoller<T extends Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJmsQueuePoller.class);
    private final AtomicBoolean isAlive = new AtomicBoolean(false);
    private final AtomicLong consecutiveErrors = new AtomicLong(0L);

    protected abstract JmsDestination getInJmsDestination();

    protected abstract JmsDestination getErrorQueueJmsDestination();

    protected abstract void afterReadingMessage(T var1) throws Exception;

    protected void onExceptionMessage(T jmsObject) {
    }

    @PostConstruct
    public void init() {
        try {
            ConnectionFactory cf = new ConnectionFactory();
            cf.setProperty("imqAddressList", this.getInJmsDestination().getUrl());
            Connection connection = (Connection)cf.createConnection();
            connection.setExceptionListener(ignore -> {
                LOG.error("Exception occured in JMS Broker. Message Details:{}", (Object)ignore.toString());
                this.isAlive.set(false);
            });
            connection.setEventListener(connEvent -> {
                String eventCode = connEvent.getEventCode();
                String eventMessage = connEvent.getEventMessage();
                if (StringUtils.isNotBlank((CharSequence)eventCode)) {
                    if (eventCode.startsWith("E2") || eventCode.equals("E401")) {
                        LOG.error("JMS broker is DISCONNECTED.");
                        this.isAlive.set(false);
                    } else if (eventCode.equals("E301")) {
                        LOG.info("CONNECTED successfully to JMS broker.");
                        this.isAlive.set(true);
                    }
                }
                LOG.info("Received JMS notification event. EventCode={}, EventMessage={}. JMS Connection={}", new Object[]{eventCode, eventMessage, this.isAlive() ? "Connected" : "Disconnected"});
            });
            connection.start();
            Session session = connection.createSession(true, 0);
            String queueName = this.getInJmsDestination().getQueueName();
            Queue queue = session.createQueue(queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            consumer.setMessageListener(message -> {
                LOG.info("Processing JMS message from queuename:{}", (Object)queueName);
                this.onMessageArrive(session, message);
            });
            this.isAlive.set(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAlive() {
        return this.isAlive.get();
    }

    public void shutdown() {
        this.isAlive.set(false);
    }

    private T unMarshalMessage(Message message) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        TextMessage textMessage = (TextMessage)message;
        JmsMessage jmsMessage = (JmsMessage)objectMapper.readValue(textMessage.getText(), JmsMessage.class);
        if (!DigestUtils.sha512Hex((String)jmsMessage.getMessage()).equals(jmsMessage.getFingerPrint())) {
            throw new JMSException("Invalid fingerprint of the jms message. Please make sure the jms message is not altered.");
        }
        Class<?> typeParameter = Generics.getTypeParameter(this.getClass());
        if (String.class.equals(typeParameter)) {
            return (T)jmsMessage.getMessage();
        }
        return (T)((Serializable)objectMapper.readValue(jmsMessage.getMessage(), typeParameter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onMessageArrive(Session session, Message message) {
        T jmsObject = null;
        try {
            jmsObject = this.unMarshalMessage(message);
            this.afterReadingMessage(jmsObject);
            this.consecutiveErrors.set(0L);
        }
        catch (Exception e) {
            try {
                this.onExceptionMessage(jmsObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sendToErrorQueue(session, message, e);
            LOG.warn("Exception while processing jms message.", (Throwable)e);
            LOG.warn("Consecutive error count = {}.", (Object)this.consecutiveErrors.incrementAndGet());
        }
        finally {
            try {
                session.commit();
            }
            catch (JMSException ignore) {
                LOG.warn("Exception occured while commiting session.", (Throwable)ignore);
                AbstractJmsQueuePoller.rollbackLogException(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToErrorQueue(Session session, Message message, Exception e) {
        LOG.info("Attempting to send mail before placing message on error queue.");
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("Could not process a jms message from queue:" + this.getInJmsDestination().toString());
            sb.append("Exception is: ");
            sb.append(e.toString());
            sb.append("\nThe message will be moved to the error queue.\n");
            sb.append("\nJMSMessageID:" + message.getJMSMessageID());
            sb.append("\nJMSDestination:" + message.getJMSDestination());
            sb.append("\n\n");
            sb.append("Stack trace is:\n");
            sb.append(ExceptionUtils.getStackTrace((Throwable)e));
            String errorMessage = sb.toString();
            LOG.error("Message placed on error queue.\n{}", (Object)errorMessage);
        }
        catch (Exception e2) {
            LOG.error("Exception occured in notifyMaxConsecutiveErrorsReached: ", (Throwable)e2);
        }
        finally {
            this.sendToErrorQueue(session, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToErrorQueue(Session session, Message message) {
        String errorQueue = this.getErrorQueueJmsDestination().getQueueName();
        Queue queue = null;
        MessageProducer producer = null;
        try {
            queue = session.createQueue(errorQueue);
            producer = session.createProducer((Destination)queue);
            LOG.info("Sending JMS message to error queue {}", (Object)errorQueue);
            producer.send(message);
            LOG.info("JMS message id: '{}' successfully sent to error queue {}.", (Object)message.getJMSMessageID(), (Object)errorQueue);
        }
        catch (JMSException e) {
            LOG.warn("Exception while sending message to error queue.", (Throwable)e);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                    LOG.info("JMS producer closed.");
                }
                catch (JMSException e) {
                    LOG.warn("Exception while closing producer.", (Throwable)e);
                }
            }
        }
    }

    private static void rollbackLogException(Session session) {
        try {
            LOG.info("Rolling back session.");
            session.rollback();
        }
        catch (JMSException e) {
            LOG.warn("Exception while rolling back session.", (Throwable)e);
        }
    }
}

