/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.jms.common.utils;

import com.sun.messaging.ConnectionFactory;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Session;
import org.lwapp.jms.common.JmsDestination;
import org.lwapp.jms.common.outgoing.JmsCallback;
import org.lwapp.jms.common.outgoing.JmsCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMqTools {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMqTools.class);

    public static void sendJmsMessage(JmsDestination jmsDestination, String message) throws Exception {
        OpenMqTools.sendJmsMessages(jmsDestination, message);
    }

    public static void sendJmsMessages(JmsDestination jmsDestination, String ... messages) throws Exception {
        OpenMqTools.runInTransactedSession(jmsDestination.getUrl(), JmsCallbacks.createJmsMessageQueueSender(jmsDestination.getQueueName(), messages));
    }

    public static void publishJmsMessage(JmsDestination jmsDestination, String message) throws Exception {
        OpenMqTools.sendJmsMessages(jmsDestination, message);
    }

    public static void publishJmsMessages(JmsDestination jmsDestination, String ... messages) throws Exception {
        OpenMqTools.runInTransactedSession(jmsDestination.getUrl(), JmsCallbacks.createJmsMessageTopicSender(jmsDestination.getTopicName(), messages));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Serializable> void runInTransactedSession(String jmsUrl, JmsCallback<T> jmsCallback) {
        Connection c = null;
        try {
            LOG.debug("Creating connection to {}.", (Object)jmsUrl);
            ConnectionFactory f = new ConnectionFactory();
            f.setProperty("imqAddressList", jmsUrl);
            c = f.createConnection();
            LOG.debug("Starting connection.");
            c.start();
            try {
                Session session = c.createSession(true, 0);
                try {
                    jmsCallback.doInJmsSession(session);
                }
                catch (Exception e) {
                    try {
                        LOG.info("Exception occured while processing. Rolling back session.", (Throwable)e);
                        session.rollback();
                    }
                    catch (Exception e1) {
                        LOG.warn("Exception while rolling back session: {}", (Object)e.getMessage(), (Object)e);
                    }
                    throw e;
                }
                finally {
                    session.close();
                    LOG.debug("Session closed.");
                }
            }
            finally {
                LOG.debug("Stopping connection.");
                c.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception exception) {}
            }
            LOG.debug("Connection closed to {}.", (Object)jmsUrl);
        }
    }
}

