package org.lwapp.notification.config;

import javax.inject.Inject;

import org.lwapp.configclient.client.ConfigurationServiceClient;
import org.lwapp.notification.jms.JmsDestination;

import com.google.common.base.Preconditions;

public class CommonNotificationsApplicationConfig {

	@Inject
	private ConfigurationServiceClient applicationConfiguration;

	public int getValueAsInt(final LwappConfigurations config) {
		return Preconditions.checkNotNull(applicationConfiguration.getInt(config), "Please provide mandatory config property: " + config);
	}

	public String getValue(final LwappConfigurations config) {
		return applicationConfiguration.getString(config);
	}

	public String getSystemEmailAddress() {
		return getValue(LwappConfigurations.SYSTEM_EMAIL_ADDRESS);
	}

	public int getMaxRetryEmailAttempts() {
		return applicationConfiguration.getInt(LwappConfigurations.MAX_EMAIL_ATTEMPTS);
	}

	public String getSmtpHost() {
		return getValue(LwappConfigurations.SMTP_HOST);
	}

	public int getMaxRetrySMSAttempts() {
		return applicationConfiguration.getInt(LwappConfigurations.MAX_SMS_ATTEMPTS);
	}

	public int getSmtpPort() {
		return applicationConfiguration.getInt(LwappConfigurations.SMTP_PORT);
	}

	public JmsDestination getEmailIncomingJmsQueue() {
		final String incomingQueue = getValue(LwappConfigurations.EMAIL_INCOMING_QUEUE);
		return new JmsDestination(getJmsUrl(), incomingQueue, incomingQueue);
	}

	public JmsDestination getEmailErrorJmsQueue() {
		final String errorQueue = getValue(LwappConfigurations.EMAIL_ERROR_QUEUE);
		return new JmsDestination(getJmsUrl(), errorQueue, errorQueue);
	}

	public JmsDestination getSmsIncomingJmsQueue() {
		final String incomingQueue = getValue(LwappConfigurations.SMS_INCOMING_QUEUE);
		return new JmsDestination(getJmsUrl(), incomingQueue, incomingQueue);
	}

	public JmsDestination getSmsErrorJmsQueue() {
		final String errorQueue = getValue(LwappConfigurations.SMS_ERROR_QUEUE);
		return new JmsDestination(getJmsUrl(), errorQueue, errorQueue);
	}

	public JmsDestination getTwitterIncomingJmsQueue() {
		final String incomingQueue = getValue(LwappConfigurations.TWITTER_INCOMING_QUEUE);
		return new JmsDestination(getJmsUrl(), incomingQueue, incomingQueue);
	}

	public JmsDestination getTwitterErrorJmsQueue() {
		final String errorQueue = getValue(LwappConfigurations.TWITTER_ERROR_QUEUE);
		return new JmsDestination(getJmsUrl(), errorQueue, errorQueue);
	}

	public String getJmsUrl() {
		return getValue(LwappConfigurations.JMS_URL);
	}

	public String getsystemEmailPassword() {
		return getValue(LwappConfigurations.STSTEM_EMAIL_PASSWORD);
	}

	public String getTechinalSupportEmailAddress() {
		return getValue(LwappConfigurations.STSTEM_TECHNICAL_SUPPORT_EMAIL_ADDRESS);
	}

	public boolean isNotificationsEnabled() {
		return applicationConfiguration.getBoolean(LwappConfigurations.ENABLE_NOTIFICATIONS);
	}

	public boolean isSmsNotificationsEnabled() {
		return applicationConfiguration.getBoolean(LwappConfigurations.ENABLE_SMS_NOTIFICATIONS);
	}

	public boolean isEmailNotificationsEnabled() {
		return applicationConfiguration.getBoolean(LwappConfigurations.ENABLE_EMAIL_NOTIFICATIONS);
	}

	public boolean isTwitterNotificationsEnabled() {
		return applicationConfiguration.getBoolean(LwappConfigurations.ENABLE_TWITTER_NOTIFICATIONS);
	}
}
