package org.lwapp.notification.email;

import java.io.Serializable;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang3.Validate;

@XmlRootElement(name = "Email")
public class Email implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private final String[] toAddresses;
    private final String subject;
    private final String messageBody;
    private final EmailAttachment[] attachments;

    @SuppressWarnings("unused")
    private Email() {
        toAddresses = null;
        subject = null;
        messageBody = null;
        this.attachments = null;
    }

    public Email(final String subject, final String messageBody, final String... toAddresses) {
        Validate.notBlank(subject, "Missing subject for email.");
        Validate.notBlank(messageBody, "Missing email message body.");
        Validate.notEmpty(toAddresses, "Missing email addresses.");
        this.toAddresses = toAddresses;
        this.subject = subject;
        this.messageBody = messageBody;
        this.attachments = null;
    }

    public Email(final List<String> toAddresses, final String subject, final String messageBody, final EmailAttachment... attachments) {
        Validate.notBlank(subject, "Missing subject for email.");
        Validate.notBlank(messageBody, "Missing email message body.");
        Validate.notNull(toAddresses, "Missing email addresses.");
        Validate.notEmpty(toAddresses.toArray(), "Missing email addresses.");
        Validate.notEmpty(attachments, "Missing email attachment.");

        this.toAddresses = toAddresses.toArray(new String[] {});
        this.subject = subject;
        this.messageBody = messageBody;
        this.attachments = attachments;
    }

    public String[] getToAddresses() {
        return toAddresses;
    }

    public String getSubject() {
        return subject;
    }

    public String getMessageBody() {
        return messageBody;
    }

    public EmailAttachment[] getAttachments() {
        return attachments;
    }

}