package org.lwapp.notification.email;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.lwapp.notification.jms.JmsDestination;
import org.lwapp.notification.jms.incoming.AbstractJmsQueuePoller;

@Singleton
public class EmailNotificationManager extends AbstractJmsQueuePoller<Email> {

	@Inject
	private EmailSender emailSender;
	@Inject
	private CommonNotificationsApplicationConfig configurationClient;

	@Override
	protected JmsDestination getInJmsDestination() {
		return configurationClient.getEmailIncomingJmsQueue();
	}

	@Override
	protected JmsDestination getErrorQueueJmsDestination() {
		return configurationClient.getEmailErrorJmsQueue();
	}

	@Override
	protected void afterReadingMessage(final Email email) throws Exception {
		emailSender.sendEmailNow(email);
	}

}
