package org.lwapp.notification.jms.outgoing;

import org.lwapp.notification.jms.JmsMessage;

public final class JmsCallbacks {

    public static JmsCallback<Class<Void>> createJmsMessageQueueSender(final String queueName, final String... messages) {
        return new JmsMessageQueueSender(queueName, messages);
    }

    public static JmsCallback<Class<Void>> createJmsMessageTopicSender(final String topicName, final String... messages) {
        return new JmsMessageTopicSender(topicName, messages);
    }

    public static JmsCallback<JmsMessage> createMessageQueueReceiver(final String queueName) {
        return new JmsMessageQueueReceiver(queueName, 1000);
    }

}