package org.lwapp.notification.twitter;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang3.Validate;

@XmlRootElement(name = "Tweet")
public class Tweet implements Serializable {

    private static final long serialVersionUID = 1L;

    private final String to;
    private final String message;

    @SuppressWarnings("unused")
    private Tweet() {
        this.to = null;
        this.message = null;
    }

    public Tweet(final String to, final String message) {
        Validate.notBlank(to, "Twitter to handle is mandatory.");
        Validate.notBlank(message, "Tweet message is mandatory.");
        this.to = to;
        this.message = message;
    }

    public String getTo() {
        return to;
    }

    public String getMessage() {
        return message;
    }

}
