/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.lwapp.notification.email.Email;
import org.lwapp.notification.email.EmailAttachment;
import org.lwapp.notification.jms.utils.OpenMqTools;
import org.lwapp.notification.sms.Sms;
import org.lwapp.notification.twitter.Tweet;

@Singleton
public final class NotificationManager {
    @Inject
    private CommonNotificationsApplicationConfig commonNotificationsApplicationConfig;

    public void sendEmail(String subject, String message, String ... recipients) throws Exception {
        if (!this.isEmailNotificationsEnabled()) {
            return;
        }
        Email email = new Email(subject, message, recipients);
        ObjectMapper objectMapper = new ObjectMapper();
        String emailJson = objectMapper.writeValueAsString((Object)email);
        OpenMqTools.sendJmsMessage(this.commonNotificationsApplicationConfig.getEmailIncomingJmsQueue(), emailJson);
    }

    public void sendEmail(String subject, String message, List<String> recipients, EmailAttachment ... attachments) throws Exception {
        if (!this.isEmailNotificationsEnabled()) {
            return;
        }
        Email email = new Email(recipients, subject, message, attachments);
        ObjectMapper objectMapper = new ObjectMapper();
        String emailJson = objectMapper.writeValueAsString((Object)email);
        OpenMqTools.sendJmsMessage(this.commonNotificationsApplicationConfig.getEmailIncomingJmsQueue(), emailJson);
    }

    public void sendSms(String msisdn, String message) throws Exception {
        if (!this.isSmsNotificationsEnabled()) {
            return;
        }
        Sms sms = new Sms(message, msisdn);
        ObjectMapper objectMapper = new ObjectMapper();
        String smsJson = objectMapper.writeValueAsString((Object)sms);
        OpenMqTools.sendJmsMessage(this.commonNotificationsApplicationConfig.getSmsIncomingJmsQueue(), smsJson);
    }

    public void tweet(String to, String message) throws Exception {
        if (!this.isTwitterNotificationsEnabled()) {
            return;
        }
        Tweet tweet = new Tweet(to, message);
        ObjectMapper objectMapper = new ObjectMapper();
        String tweetJson = objectMapper.writeValueAsString((Object)tweet);
        OpenMqTools.sendJmsMessage(this.commonNotificationsApplicationConfig.getTwitterIncomingJmsQueue(), tweetJson);
    }

    private boolean isEmailNotificationsEnabled() {
        return this.commonNotificationsApplicationConfig.isNotificationsEnabled() && this.commonNotificationsApplicationConfig.isEmailNotificationsEnabled();
    }

    private boolean isSmsNotificationsEnabled() {
        return this.commonNotificationsApplicationConfig.isNotificationsEnabled() && this.commonNotificationsApplicationConfig.isSmsNotificationsEnabled();
    }

    private boolean isTwitterNotificationsEnabled() {
        return this.commonNotificationsApplicationConfig.isNotificationsEnabled() && this.commonNotificationsApplicationConfig.isTwitterNotificationsEnabled();
    }
}

