/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.config;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.lwapp.configclient.Configurable;
import org.lwapp.configclient.client.ConfigurationServiceClient;
import org.lwapp.notification.config.LwappConfigurations;
import org.lwapp.notification.jms.JmsDestination;

public class CommonNotificationsApplicationConfig {
    @Inject
    private ConfigurationServiceClient applicationConfiguration;

    public int getValueAsInt(LwappConfigurations config) {
        return (Integer)Preconditions.checkNotNull((Object)this.applicationConfiguration.getInt((Configurable)config), (Object)("Please provide mandatory config property: " + (Object)((Object)config)));
    }

    public String getValue(LwappConfigurations config) {
        return this.applicationConfiguration.getString((Configurable)config);
    }

    public String getSystemEmailAddress() {
        return this.getValue(LwappConfigurations.SYSTEM_EMAIL_ADDRESS);
    }

    public int getMaxRetryEmailAttempts() {
        return this.applicationConfiguration.getInt((Configurable)LwappConfigurations.MAX_EMAIL_ATTEMPTS);
    }

    public String getSmtpHost() {
        return this.getValue(LwappConfigurations.SMTP_HOST);
    }

    public int getMaxRetrySMSAttempts() {
        return this.applicationConfiguration.getInt((Configurable)LwappConfigurations.MAX_SMS_ATTEMPTS);
    }

    public int getSmtpPort() {
        return this.applicationConfiguration.getInt((Configurable)LwappConfigurations.SMTP_PORT);
    }

    public JmsDestination getEmailIncomingJmsQueue() {
        String incomingQueue = this.getValue(LwappConfigurations.EMAIL_INCOMING_QUEUE);
        return new JmsDestination(this.getJmsUrl(), incomingQueue, incomingQueue);
    }

    public JmsDestination getEmailErrorJmsQueue() {
        String errorQueue = this.getValue(LwappConfigurations.EMAIL_ERROR_QUEUE);
        return new JmsDestination(this.getJmsUrl(), errorQueue, errorQueue);
    }

    public JmsDestination getSmsIncomingJmsQueue() {
        String incomingQueue = this.getValue(LwappConfigurations.SMS_INCOMING_QUEUE);
        return new JmsDestination(this.getJmsUrl(), incomingQueue, incomingQueue);
    }

    public JmsDestination getSmsErrorJmsQueue() {
        String errorQueue = this.getValue(LwappConfigurations.SMS_ERROR_QUEUE);
        return new JmsDestination(this.getJmsUrl(), errorQueue, errorQueue);
    }

    public JmsDestination getTwitterIncomingJmsQueue() {
        String incomingQueue = this.getValue(LwappConfigurations.TWITTER_INCOMING_QUEUE);
        return new JmsDestination(this.getJmsUrl(), incomingQueue, incomingQueue);
    }

    public JmsDestination getTwitterErrorJmsQueue() {
        String errorQueue = this.getValue(LwappConfigurations.TWITTER_ERROR_QUEUE);
        return new JmsDestination(this.getJmsUrl(), errorQueue, errorQueue);
    }

    public String getJmsUrl() {
        return this.getValue(LwappConfigurations.JMS_URL);
    }

    public String getsystemEmailPassword() {
        return this.getValue(LwappConfigurations.STSTEM_EMAIL_PASSWORD);
    }

    public String getTechinalSupportEmailAddress() {
        return this.getValue(LwappConfigurations.STSTEM_TECHNICAL_SUPPORT_EMAIL_ADDRESS);
    }

    public boolean isNotificationsEnabled() {
        return this.applicationConfiguration.getBoolean((Configurable)LwappConfigurations.ENABLE_NOTIFICATIONS);
    }

    public boolean isSmsNotificationsEnabled() {
        return this.applicationConfiguration.getBoolean((Configurable)LwappConfigurations.ENABLE_SMS_NOTIFICATIONS);
    }

    public boolean isEmailNotificationsEnabled() {
        return this.applicationConfiguration.getBoolean((Configurable)LwappConfigurations.ENABLE_EMAIL_NOTIFICATIONS);
    }

    public boolean isTwitterNotificationsEnabled() {
        return this.applicationConfiguration.getBoolean((Configurable)LwappConfigurations.ENABLE_TWITTER_NOTIFICATIONS);
    }
}

