/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lwapp.configclient.Configurable;
import org.lwapp.configclient.Configuration;

public enum LwappConfigurations implements Configurable
{
    ENABLE_NOTIFICATIONS("application.send.notifications", "false"),
    ENABLE_SMS_NOTIFICATIONS("application.enable.sms.notifications", "false"),
    ENABLE_EMAIL_NOTIFICATIONS("application.enable.email.notifications", "false"),
    ENABLE_TWITTER_NOTIFICATIONS("application.enable.twitter.notifications", "false"),
    SMTP_HOST("mail.smtp.host", "localhost"),
    MAX_EMAIL_ATTEMPTS("mail.maxattempts", "3"),
    MAX_SMS_ATTEMPTS("sms.maxattempts", "3"),
    SYSTEM_EMAIL_ADDRESS("system.email.address", "no-reply@no-reply.com"),
    STSTEM_EMAIL_PASSWORD("system.email.password", "password", true),
    STSTEM_TECHNICAL_SUPPORT_EMAIL_ADDRESS("system.technical.support.email.address", "tectsupport@lwapp.org"),
    SMTP_PORT("application.smtp.port", "25"),
    SYSTEM_SMS_NUMBER("system.sms.number"),
    JMS_URL("system.jms.url", "localhost:7676"),
    EMAIL_INCOMING_QUEUE("system.email.incoming.queue", "EmailIncomingJmsQueue"),
    EMAIL_ERROR_QUEUE("system.email.error.queue", "EmailIncomingJmsErrorQueue"),
    SMS_INCOMING_QUEUE("system.sms.incoming.queue", "SmsIncomingJmsQueue"),
    SMS_ERROR_QUEUE("system.sms.error.queue", "SmsIncomingJmsErrorQueue"),
    TWITTER_INCOMING_QUEUE("system.twitter.incoming.queue", "TwitterIncomingJmsQueue"),
    TWITTER_ERROR_QUEUE("system.twitter.error.queue", "TwitterIncomingJmsErrorQueue");

    private final Configuration configuration;

    private LwappConfigurations(String propertyName, String defaultValue, boolean secure) {
        this(propertyName, defaultValue, null, secure);
    }

    private LwappConfigurations(String propertyName, String defaultValue, String desc) {
        this(propertyName, defaultValue, desc, false);
    }

    private LwappConfigurations(String propertyName) {
        this(propertyName, null, null, false);
    }

    private LwappConfigurations(String propertyName, String defaultValue) {
        this(propertyName, defaultValue, null, false);
    }

    private LwappConfigurations(String propertyName, String defaultValue, String description, boolean secure) {
        this.configuration = new Configuration.Builder().propertyName(propertyName).defaultValue(defaultValue).description(description).secure(secure).build();
    }

    public static List<Configuration> getConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (LwappConfigurations config : LwappConfigurations.values()) {
            configurations.add(config.configuration);
        }
        return Collections.unmodifiableList(configurations);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

