/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.email;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.lwapp.notification.email.Email;
import org.lwapp.notification.email.EmailSender;
import org.lwapp.notification.jms.JmsDestination;
import org.lwapp.notification.jms.incoming.AbstractJmsQueuePoller;

@Singleton
public class EmailNotificationManager
extends AbstractJmsQueuePoller<Email> {
    @Inject
    private EmailSender emailSender;
    @Inject
    private CommonNotificationsApplicationConfig configurationClient;

    @Override
    protected JmsDestination getInJmsDestination() {
        return this.configurationClient.getEmailIncomingJmsQueue();
    }

    @Override
    protected JmsDestination getErrorQueueJmsDestination() {
        return this.configurationClient.getEmailErrorJmsQueue();
    }

    @Override
    protected void afterReadingMessage(Email email) throws Exception {
        this.emailSender.sendEmailNow(email);
    }
}

