/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.jms.outgoing;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.codec.digest.DigestUtils;
import org.lwapp.notification.jms.JmsMessage;
import org.lwapp.notification.jms.outgoing.JmsCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsMessageQueueReceiver
implements JmsCallback<JmsMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(JmsMessageQueueReceiver.class);
    private final String queueName;
    private final long timeoutMillis;

    JmsMessageQueueReceiver(String queueName, long timeoutMillis) {
        this.queueName = queueName;
        this.timeoutMillis = timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JmsMessage doInJmsSession(Session session) throws Exception {
        JmsMessage jmsMessage;
        Queue queue = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        LOG.debug("Consumer created for queue '{}'.", (Object)this.queueName);
        try {
            Message message = consumer.receive(this.timeoutMillis);
            TextMessage textMessage = (TextMessage)message;
            ObjectMapper objectMapper = new ObjectMapper();
            jmsMessage = (JmsMessage)objectMapper.readValue(textMessage.getText(), JmsMessage.class);
            if (!DigestUtils.sha512Hex((String)jmsMessage.getMessage()).equals(jmsMessage.getFingerPrint())) {
                throw new Exception("Invalid fingerprint of the jms message. Please make sure the jms message is not altered.");
            }
        }
        finally {
            consumer.close();
            LOG.debug("Consumer closed.");
        }
        session.commit();
        return jmsMessage;
    }
}

