/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.jms.outgoing;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.Validate;
import org.lwapp.notification.jms.JmsMessage;
import org.lwapp.notification.jms.outgoing.JmsCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class JmsMessageQueueSender
implements JmsCallback<Class<Void>> {
    private static final Logger LOG = LoggerFactory.getLogger(JmsMessageQueueSender.class);
    private final String queueName;
    private final String[] messages;

    JmsMessageQueueSender(String queueName, String ... messages) {
        Validate.notBlank((CharSequence)queueName, (String)"Queue name is mandatory.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])messages, (String)"There must be atleast one message to send to the queue.", (Object[])new Object[0]);
        this.queueName = queueName;
        this.messages = messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<Void> doInJmsSession(Session session) throws Exception {
        Queue queue = session.createQueue(this.queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        try {
            LOG.debug("Sending {} JMS message(s) to '{}' queue.", (Object)this.messages.length, (Object)this.queueName);
            for (String message : this.messages) {
                JmsMessage jmsMessage = new JmsMessage();
                jmsMessage.setMessage(message);
                jmsMessage.setFingerPrint(DigestUtils.sha512Hex((String)message));
                jmsMessage.setLogTraceId(MDC.get((String)"logTraceId"));
                LOG.debug("Send message.");
                ObjectMapper objectMapper = new ObjectMapper();
                String jmsJsonMessage = objectMapper.writeValueAsString((Object)jmsMessage);
                TextMessage textMessage = session.createTextMessage(jmsJsonMessage);
                textMessage.setBooleanProperty("JMS_SUN_COMPRESS", true);
                producer.send((Message)textMessage);
            }
            LOG.debug("JMS messages sent.");
        }
        finally {
            producer.close();
            LOG.debug("JMS producer closed.");
        }
        session.commit();
        return Void.TYPE;
    }
}

