/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.jms.utils;

import com.sun.messaging.ConnectionFactory;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.lwapp.notification.jms.JmsDestination;
import org.lwapp.notification.jms.JmsMessage;
import org.lwapp.notification.jms.outgoing.JmsCallback;
import org.lwapp.notification.jms.outgoing.JmsCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMqTools {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMqTools.class);

    public static JmsMessage receiveMessage(JmsDestination jmsDestination) throws Exception {
        return OpenMqTools.runInTransactedSession(jmsDestination.getHost(), JmsCallbacks.createMessageQueueReceiver(jmsDestination.getQueueName()));
    }

    public static void sendJmsMessage(JmsDestination jmsDestination, String message) throws Exception {
        OpenMqTools.sendJmsMessages(jmsDestination, message);
    }

    public static void sendJmsMessages(JmsDestination jmsDestination, String ... messages) throws Exception {
        OpenMqTools.runInTransactedSession(jmsDestination.getHost(), JmsCallbacks.createJmsMessageQueueSender(jmsDestination.getQueueName(), messages));
    }

    public static void publishJmsMessage(JmsDestination jmsDestination, String message) throws Exception {
        OpenMqTools.sendJmsMessages(jmsDestination, message);
    }

    public static void publishJmsMessages(JmsDestination jmsDestination, String ... messages) throws Exception {
        OpenMqTools.runInTransactedSession(jmsDestination.getHost(), JmsCallbacks.createJmsMessageTopicSender(jmsDestination.getTopicName(), messages));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T runInTransactedSession(String jmsUrl, JmsCallback<T> jmsCallback) throws Exception {
        LOG.debug("Creating connection to {}.", (Object)jmsUrl);
        Connection c = OpenMqTools.createConnection(jmsUrl);
        try {
            T t;
            LOG.debug("Starting connection.");
            c.start();
            try {
                t = OpenMqTools.createTransactedSessionAndRun(c, jmsCallback);
            }
            catch (Throwable throwable) {
                LOG.debug("Stopping connection.");
                c.stop();
                throw throwable;
            }
            LOG.debug("Stopping connection.");
            c.stop();
            return t;
        }
        finally {
            c.close();
            LOG.debug("Connection closed to {}.", (Object)jmsUrl);
        }
    }

    private static Connection createConnection(String jmsUrl) throws JMSException {
        ConnectionFactory f = new ConnectionFactory();
        f.setProperty("imqAddressList", jmsUrl);
        return f.createConnection();
    }

    private static <T> T createTransactedSessionAndRun(Connection c, JmsCallback<T> jmsCallback) throws Exception {
        Session session = c.createSession(true, 0);
        try {
            T t = jmsCallback.doInJmsSession(session);
            return t;
        }
        catch (Exception e) {
            OpenMqTools.rollbackLogException(session);
            throw e;
        }
        finally {
            session.close();
            LOG.debug("Session closed.");
        }
    }

    private static void rollbackLogException(Session session) {
        try {
            LOG.info("Rolling back session.");
            session.rollback();
        }
        catch (Exception e) {
            LOG.warn("Exception while rolling back session: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

