package org.lwapp.notification.config;

import javax.inject.Inject;

import org.lwapp.configclient.client.ConfigurationServiceClient;
import org.lwapp.notification.jms.JmsDestination;

import com.google.common.base.Preconditions;

public class CommonNotificationsApplicationConfig {

	@Inject
	private ConfigurationServiceClient applicationConfiguration;

	public String getValue(final Configurations config) {
		return Preconditions.checkNotNull(applicationConfiguration.getString(config, ""), "Please provide mandatory config property: " + config);
	}

	public int getValueAsInt(final Configurations config) {
		return Preconditions.checkNotNull(applicationConfiguration.getInt(config), "Please provide mandatory config property: " + config);
	}

	public String getValue(final Configurations config, final String defaultValue) {
		return applicationConfiguration.getString(config, defaultValue);
	}

	public int getInt(final Configurations config, final int defaultValue) {
		return applicationConfiguration.getInt(config, defaultValue);
	}

	public boolean getBoolean(final Configurations config, final boolean defaultValue) {
		return applicationConfiguration.getBoolean(config, defaultValue);
	}

	public String getSystemEmailAddress() {
		return getValue(Configurations.SYSTEM_EMAIL_ADDRESS, "no-reply@boridand.com");
	}

	public int getMaxRetryEmailAttempts() {
		return getInt(Configurations.MAX_EMAIL_ATTEMPTS, 3);
	}

	public String getSmtpHost() {
		return getValue(Configurations.SMTP_HOST);
	}

	public int getMaxRetrySMSAttempts() {
		return getInt(Configurations.MAX_SMS_ATTEMPTS, 3);
	}

	public int getSmtpPort() {
		return getInt(Configurations.SMTP_PORT, 25);
	}

	public JmsDestination getEmailIncomingJmsQueue() {
		final String incomingQueue = getValue(Configurations.EMAIL_INCOMING_QUEUE);
		return new JmsDestination(getJmsUrl(), incomingQueue, incomingQueue);
	}

	public JmsDestination getEmailErrorJmsQueue() {
		final String errorQueue = getValue(Configurations.EMAIL_ERROR_QUEUE);
		return new JmsDestination(getJmsUrl(), errorQueue, errorQueue);
	}

	public JmsDestination getSmsIncomingJmsQueue() {
		final String incomingQueue = getValue(Configurations.SMS_INCOMING_QUEUE);
		return new JmsDestination(getJmsUrl(), incomingQueue, incomingQueue);
	}

	public JmsDestination getSmsErrorJmsQueue() {
		final String errorQueue = getValue(Configurations.SMS_ERROR_QUEUE);
		return new JmsDestination(getJmsUrl(), errorQueue, errorQueue);
	}

	public JmsDestination getTwitterIncomingJmsQueue() {
		final String incomingQueue = getValue(Configurations.TWITTER_INCOMING_QUEUE);
		return new JmsDestination(getJmsUrl(), incomingQueue, incomingQueue);
	}

	public JmsDestination getTwitterErrorJmsQueue() {
		final String errorQueue = getValue(Configurations.TWITTER_ERROR_QUEUE);
		return new JmsDestination(getJmsUrl(), errorQueue, errorQueue);
	}

	public String getJmsUrl() {
		return getValue(Configurations.JMS_URL, "localhost:7676");
	}

	public String getsystemEmailPassword() {
		return getValue(Configurations.STSTEM_EMAIL_PASSWORD);
	}

	public String getTechinalSupportEmailAddress() {
		return getValue(Configurations.STSTEM_TECHNICAL_SUPPORT_EMAIL_ADDRESS);
	}

	public boolean isNotificationsEnabled() {
		return getBoolean(Configurations.ENABLE_NOTIFICATIONS, false);
	}

	public boolean isSmsNotificationsEnabled() {
		return getBoolean(Configurations.ENABLE_SMS_NOTIFICATIONS, false);
	}

	public boolean isEmailNotificationsEnabled() {
		return getBoolean(Configurations.ENABLE_EMAIL_NOTIFICATIONS, true);
	}

	public boolean isTwitterNotificationsEnabled() {
		return getBoolean(Configurations.ENABLE_TWITTER_NOTIFICATIONS, false);
	}
}
