package org.lwapp.notification.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.lwapp.configclient.Configurable;

public enum Configurations implements Configurable {

	ENABLE_NOTIFICATIONS("application.send.notifications"), //
	ENABLE_SMS_NOTIFICATIONS("application.enable.sms.notifications"), //
	ENABLE_EMAIL_NOTIFICATIONS("application.enable.email.notifications"), //
	ENABLE_TWITTER_NOTIFICATIONS("application.enable.twitter.notifications"), //
	SMTP_HOST("mail.smtp.host"), //
	MAX_EMAIL_ATTEMPTS("mail.maxattempts"), //
	MAX_SMS_ATTEMPTS("sms.maxattempts"), //
	SYSTEM_EMAIL_ADDRESS("system.email.address"), //
	STSTEM_EMAIL_PASSWORD("system.email.password"), //
	STSTEM_TECHNICAL_SUPPORT_EMAIL_ADDRESS("system.technical.support.email.address"), //
	SMTP_PORT("application.smtp.port"), //
	SYSTEM_SMS_NUMBER("system.sms.number"), //
	JMS_URL("system.jms.url"), //
	EMAIL_INCOMING_QUEUE("system.email.incoming.queue"), //
	EMAIL_ERROR_QUEUE("system.email.error.queue"), //
	SMS_INCOMING_QUEUE("system.sms.incoming.queue"), //
	SMS_ERROR_QUEUE("system.sms.error.queue"), //
	TWITTER_INCOMING_QUEUE("system.twitter.incoming.queue"), //
	TWITTER_ERROR_QUEUE("system.twitter.error.queue"),

	;

	private final String propertyName;

	Configurations(final String name) {
		this.propertyName = name;
	}

	@Override
	public String getPropertyName() {
		return propertyName;
	}

	public static List<String> getConfigurations() {
		final List<String> configurations = new ArrayList<>();
		for (final Configurations config : Configurations.values()) {
			configurations.add(config.getPropertyName());
		}

		return Collections.unmodifiableList(configurations);
	}

}
