package org.lwapp.notification.error;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.lwapp.notification.NotificationManager;
import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ErrorNotifier {
	private static final Logger LOG = LoggerFactory.getLogger(ErrorNotifier.class);

	@Inject
	private NotificationManager notificationManager;
	@Inject
	private CommonNotificationsApplicationConfig configurationClient;

	public void notifyAlert(final String subject, final String message) {
		try {
			notificationManager.sendEmail(subject, message, configurationClient.getTechinalSupportEmailAddress());
		} catch (final Exception e) {
			LOG.error("Exception occured while notifying technical support.", e);
		}
	}

}
