package org.lwapp.notification.sms;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang3.Validate;

@XmlRootElement(name = "Sms")
public class Sms implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private final String[] toNumbers;
    private final String messageBody;

    @SuppressWarnings("unused")
    private Sms() {
        this.toNumbers = null;
        this.messageBody = null;

    }

    public Sms(final String messageBody, final String... toAddresses) {
        Validate.notEmpty(toAddresses, "No toNumber is provided.");
        Validate.notBlank(messageBody, "No message is provided.");
        this.toNumbers = toAddresses;
        this.messageBody = messageBody;
    }

    public String[] getToNumbers() {
        return toNumbers;
    }

    public String getMessageBody() {
        return messageBody;
    }

}
