package org.lwapp.notification.sms;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.lwapp.notification.jms.JmsDestination;
import org.lwapp.notification.jms.incoming.AbstractJmsQueuePoller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SmsNotificationManager extends AbstractJmsQueuePoller<Sms> {
	private static final Logger LOG = LoggerFactory.getLogger(SmsNotificationManager.class);

	@Inject
	private CommonNotificationsApplicationConfig configurationClient;

	@Override
	protected JmsDestination getInJmsDestination() {
		return configurationClient.getSmsIncomingJmsQueue();
	}

	@Override
	protected JmsDestination getErrorQueueJmsDestination() {
		return configurationClient.getSmsErrorJmsQueue();
	}

	@Override
	protected void afterReadingMessage(final Sms sms) throws Exception {
		sendMessageNow(sms);
	}

	private void sendMessageNow(final Sms sms) {
		for (final String to : sms.getToNumbers()) {
			LOG.info("Sending SMS to :{}", to);

			// TODO: write code to send real sms
		}
	}
}
