package org.lwapp.notification.twitter;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.lwapp.notification.jms.JmsDestination;
import org.lwapp.notification.jms.incoming.AbstractJmsQueuePoller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TwitterNotificationManager extends AbstractJmsQueuePoller<Tweet> {
	private static final Logger LOG = LoggerFactory.getLogger(TwitterNotificationManager.class);

	@Inject
	private CommonNotificationsApplicationConfig configurationClient;

	@Override
	protected JmsDestination getInJmsDestination() {
		return configurationClient.getTwitterIncomingJmsQueue();
	}

	@Override
	protected JmsDestination getErrorQueueJmsDestination() {
		return configurationClient.getTwitterErrorJmsQueue();
	}

	@Override
	protected void afterReadingMessage(final Tweet tweetRequest) throws Exception {
		tweet(tweetRequest.getTo(), tweetRequest.getMessage());
	}

	private void tweet(final String to, final String message) {
		LOG.info("Sending twitter:\n@{},\t{}", to, message);

		// FIXME: Add twitter related code
	}
}
