/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.config;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.lwapp.configclient.Configurable;
import org.lwapp.configclient.client.ConfigurationServiceClient;
import org.lwapp.notification.config.Configurations;
import org.lwapp.notification.jms.JmsDestination;

public class CommonNotificationsApplicationConfig {
    @Inject
    private ConfigurationServiceClient applicationConfiguration;

    public String getValue(Configurations config) {
        return (String)Preconditions.checkNotNull((Object)this.applicationConfiguration.getString((Configurable)config, ""), (Object)("Please provide mandatory config property: " + (Object)((Object)config)));
    }

    public int getValueAsInt(Configurations config) {
        return (Integer)Preconditions.checkNotNull((Object)this.applicationConfiguration.getInt((Configurable)config), (Object)("Please provide mandatory config property: " + (Object)((Object)config)));
    }

    public String getValue(Configurations config, String defaultValue) {
        return this.applicationConfiguration.getString((Configurable)config, defaultValue);
    }

    public int getInt(Configurations config, int defaultValue) {
        return this.applicationConfiguration.getInt((Configurable)config, defaultValue);
    }

    public boolean getBoolean(Configurations config, boolean defaultValue) {
        return this.applicationConfiguration.getBoolean((Configurable)config, defaultValue);
    }

    public String getSystemEmailAddress() {
        return this.getValue(Configurations.SYSTEM_EMAIL_ADDRESS, "no-reply@boridand.com");
    }

    public int getMaxRetryEmailAttempts() {
        return this.getInt(Configurations.MAX_EMAIL_ATTEMPTS, 3);
    }

    public String getSmtpHost() {
        return this.getValue(Configurations.SMTP_HOST);
    }

    public int getMaxRetrySMSAttempts() {
        return this.getInt(Configurations.MAX_SMS_ATTEMPTS, 3);
    }

    public int getSmtpPort() {
        return this.getInt(Configurations.SMTP_PORT, 25);
    }

    public JmsDestination getEmailIncomingJmsQueue() {
        String incomingQueue = this.getValue(Configurations.EMAIL_INCOMING_QUEUE);
        return new JmsDestination(this.getJmsUrl(), incomingQueue, incomingQueue);
    }

    public JmsDestination getEmailErrorJmsQueue() {
        String errorQueue = this.getValue(Configurations.EMAIL_ERROR_QUEUE);
        return new JmsDestination(this.getJmsUrl(), errorQueue, errorQueue);
    }

    public JmsDestination getSmsIncomingJmsQueue() {
        String incomingQueue = this.getValue(Configurations.SMS_INCOMING_QUEUE);
        return new JmsDestination(this.getJmsUrl(), incomingQueue, incomingQueue);
    }

    public JmsDestination getSmsErrorJmsQueue() {
        String errorQueue = this.getValue(Configurations.SMS_ERROR_QUEUE);
        return new JmsDestination(this.getJmsUrl(), errorQueue, errorQueue);
    }

    public JmsDestination getTwitterIncomingJmsQueue() {
        String incomingQueue = this.getValue(Configurations.TWITTER_INCOMING_QUEUE);
        return new JmsDestination(this.getJmsUrl(), incomingQueue, incomingQueue);
    }

    public JmsDestination getTwitterErrorJmsQueue() {
        String errorQueue = this.getValue(Configurations.TWITTER_ERROR_QUEUE);
        return new JmsDestination(this.getJmsUrl(), errorQueue, errorQueue);
    }

    public String getJmsUrl() {
        return this.getValue(Configurations.JMS_URL, "localhost:7676");
    }

    public String getsystemEmailPassword() {
        return this.getValue(Configurations.STSTEM_EMAIL_PASSWORD);
    }

    public String getTechinalSupportEmailAddress() {
        return this.getValue(Configurations.STSTEM_TECHNICAL_SUPPORT_EMAIL_ADDRESS);
    }

    public boolean isNotificationsEnabled() {
        return this.getBoolean(Configurations.ENABLE_NOTIFICATIONS, false);
    }

    public boolean isSmsNotificationsEnabled() {
        return this.getBoolean(Configurations.ENABLE_SMS_NOTIFICATIONS, false);
    }

    public boolean isEmailNotificationsEnabled() {
        return this.getBoolean(Configurations.ENABLE_EMAIL_NOTIFICATIONS, true);
    }

    public boolean isTwitterNotificationsEnabled() {
        return this.getBoolean(Configurations.ENABLE_TWITTER_NOTIFICATIONS, false);
    }
}

