/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.email;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.Validate;
import org.lwapp.notification.email.EmailAttachment;

@XmlRootElement(name="Email")
public class Email
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] toAddresses;
    private final String subject;
    private final String messageBody;
    private final EmailAttachment[] attachments;

    private Email() {
        this.toAddresses = null;
        this.subject = null;
        this.messageBody = null;
        this.attachments = null;
    }

    public Email(String subject, String messageBody, String ... toAddresses) {
        Validate.notBlank((CharSequence)subject, (String)"Missing subject for email.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageBody, (String)"Missing email message body.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])toAddresses, (String)"Missing email addresses.", (Object[])new Object[0]);
        this.toAddresses = toAddresses;
        this.subject = subject;
        this.messageBody = messageBody;
        this.attachments = null;
    }

    public Email(List<String> toAddresses, String subject, String messageBody, EmailAttachment ... attachments) {
        Validate.notBlank((CharSequence)subject, (String)"Missing subject for email.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageBody, (String)"Missing email message body.", (Object[])new Object[0]);
        Validate.notNull(toAddresses, (String)"Missing email addresses.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])toAddresses.toArray(), (String)"Missing email addresses.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])attachments, (String)"Missing email attachment.", (Object[])new Object[0]);
        this.toAddresses = toAddresses.toArray(new String[0]);
        this.subject = subject;
        this.messageBody = messageBody;
        this.attachments = attachments;
    }

    public String[] getToAddresses() {
        return this.toAddresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public EmailAttachment[] getAttachments() {
        return this.attachments;
    }
}

