/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.email;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.lwapp.notification.email.Email;
import org.lwapp.notification.email.EmailAttachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmailSender {
    private static final Logger LOG = LoggerFactory.getLogger(EmailSender.class);
    private final AtomicLong counter = new AtomicLong(1L);
    public static final String LF = System.getProperty("line.separator", "\n");
    @Inject
    private CommonNotificationsApplicationConfig configurationClient;

    public void sendEmailNow(Email aEmail) throws Exception {
        this.sendEmailUsingJavaMail(aEmail.getToAddresses(), aEmail.getSubject(), aEmail.getMessageBody(), aEmail.getAttachments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEmailUsingJavaMail(String[] toAddresses, String subject, String messageBody, EmailAttachment[] aAttachments) throws Exception {
        Validate.notEmpty((Object[])toAddresses, (String)"To email address is mandatory.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)subject, (String)"Subject is mandatory.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)messageBody, (String)"Email messageBody is mandatory.", (Object[])new Object[0]);
        Properties mailServerProperties = new Properties();
        mailServerProperties.put("mail.smtp.port", "587");
        mailServerProperties.put("mail.smtp.auth", "true");
        mailServerProperties.put("mail.smtp.starttls.enable", "true");
        Session getMailSession = Session.getInstance((Properties)mailServerProperties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailSender.this.configurationClient.getSystemEmailAddress(), EmailSender.this.configurationClient.getsystemEmailPassword());
            }
        });
        String aFromAddress = "no-reply@boridand.com";
        List<File> tempAttachmentFiles = null;
        try {
            LOG.debug("Building email message...");
            MimeMessage mimeMessage = new MimeMessage(getMailSession);
            mimeMessage.setFrom((Address)new InternetAddress("no-reply@boridand.com"));
            mimeMessage.setReplyTo((Address[])new InternetAddress[]{new InternetAddress("no-reply@boridand.com")});
            List<InternetAddress> address = EmailSender.convertEmailAddressesToInterNetAddresses(toAddresses);
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])address.toArray(new InternetAddress[0]));
            mimeMessage.setSubject(subject);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setText(messageBody);
            if (aAttachments != null && aAttachments.length > 0) {
                tempAttachmentFiles = this.addAttachments(aAttachments, (Message)mimeMessage, messageBody);
            }
            LOG.debug("Sending message to " + StringUtils.join((Object[])toAddresses, (String)" "));
            try (Transport transport = getMailSession.getTransport("smtp");){
                transport.connect("smtp.gmail.com", "", "");
                transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            }
            LOG.info("Message sent successfully!");
        }
        catch (MessagingException mex) {
            LOG.error("Could not send messages to all recepients.", (Throwable)mex);
            this.logSendProblems(mex, LOG);
            throw mex;
        }
        finally {
            try {
                if (tempAttachmentFiles != null) {
                    for (File file : tempAttachmentFiles) {
                        file.delete();
                    }
                }
            }
            catch (Exception ex) {
                LOG.debug("Ignore. Could not delete the file. Delete the temp files manually", (Throwable)ex);
            }
        }
    }

    private void logSendProblems(MessagingException mex, Logger aLogger) {
        Throwable ex = mex;
        do {
            Address[] validSent;
            Address[] validUnsent;
            if (!(ex instanceof SendFailedException)) continue;
            SendFailedException sfex = (SendFailedException)ex;
            Address[] invalid = sfex.getInvalidAddresses();
            if (invalid != null) {
                aLogger.error("    ** Invalid Addresses");
                for (Address element : invalid) {
                    aLogger.error("         " + element);
                }
            }
            if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                aLogger.error("    ** ValidUnsent Addresses");
                for (Address element : validUnsent) {
                    aLogger.error("         " + element);
                }
            }
            if ((validSent = sfex.getValidSentAddresses()) == null) continue;
            aLogger.error("    ** ValidSent Addresses");
            for (Address element : validSent) {
                aLogger.error("         " + element);
            }
        } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
    }

    private List<File> addAttachments(EmailAttachment[] emailAttachments, Message aMsg, String aMessageBody) throws Exception {
        ArrayList<File> temperoryAttachmentFiles = new ArrayList<File>();
        if (emailAttachments == null) {
            return temperoryAttachmentFiles;
        }
        String attachmentErrorStr = "";
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(aMessageBody);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (EmailAttachment emailAttachment : emailAttachments) {
            if (emailAttachment == null) continue;
            String attachmentName = emailAttachment.getAttachmentName();
            File fileToAttach = File.createTempFile(String.valueOf(this.counter.incrementAndGet()), "");
            temperoryAttachmentFiles.add(fileToAttach);
            FileUtils.writeByteArrayToFile((File)fileToAttach, (byte[])emailAttachment.getByteAttay());
            if (!fileToAttach.exists()) {
                throw new RuntimeException("Could not able to create attachment file at: " + fileToAttach.getParent());
            }
            try {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(fileToAttach);
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)source));
                mimeBodyPart.setFileName(attachmentName);
                multipart.addBodyPart((BodyPart)mimeBodyPart);
            }
            catch (MessagingException attachmentEx) {
                attachmentErrorStr = attachmentErrorStr + LF + attachmentName;
                LOG.warn("Failed to attach: " + attachmentName, (Throwable)attachmentEx);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)attachmentErrorStr)) {
            messageBodyPart.setText(aMessageBody + LF + "Faild to attach the following files: " + attachmentErrorStr);
        }
        aMsg.setContent((Multipart)multipart);
        aMsg.saveChanges();
        return temperoryAttachmentFiles;
    }

    private static List<InternetAddress> convertEmailAddressesToInterNetAddresses(String[] aToAddresses) throws AddressException {
        Validate.notEmpty((Object[])aToAddresses, (String)"To email address is mandatory.", (Object[])new Object[0]);
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>();
        for (String toAddress : aToAddresses) {
            result.add(new InternetAddress(toAddress));
        }
        return result;
    }
}

