/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.error;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.lwapp.notification.NotificationManager;
import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ErrorNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorNotifier.class);
    @Inject
    private NotificationManager notificationManager;
    @Inject
    private CommonNotificationsApplicationConfig configurationClient;

    public void notifyAlert(String subject, String message) {
        try {
            this.notificationManager.sendEmail(subject, message, this.configurationClient.getTechinalSupportEmailAddress());
        }
        catch (Exception e) {
            LOG.error("Exception occured while notifying technical support.", (Throwable)e);
        }
    }
}

