/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.jms.incoming;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.jms.Connection;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.lwapp.notification.error.ErrorNotifier;
import org.lwapp.notification.jms.JmsDestination;
import org.lwapp.notification.jms.JmsMessage;
import org.lwapp.notification.utils.Generics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJmsQueuePoller<T extends Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJmsQueuePoller.class);
    private static final int MAX_CONSECUTIVE_ERRORS = 5;
    private final AtomicBoolean isAlive = new AtomicBoolean(false);
    private final AtomicLong consecutiveErrors = new AtomicLong(0L);
    @Inject
    protected ErrorNotifier errorNotifier;

    protected abstract JmsDestination getInJmsDestination();

    protected abstract JmsDestination getErrorQueueJmsDestination();

    protected abstract void afterReadingMessage(T var1) throws Exception;

    @PostConstruct
    public void init() throws Exception {
        ConnectionFactory cf = new ConnectionFactory();
        cf.setProperty("imqAddressList", this.getInJmsDestination().getHost());
        Connection connection = (Connection)cf.createConnection();
        connection.setExceptionListener(ignore -> {
            LOG.error("Exception occured in JMS Broker. Message Details:{}", (Object)ignore.toString());
            this.isAlive.set(false);
        });
        connection.setEventListener(connEvent -> {
            String eventCode = connEvent.getEventCode();
            String eventMessage = connEvent.getEventMessage();
            if (StringUtils.isNotBlank((CharSequence)eventCode)) {
                if (eventCode.startsWith("E2") || eventCode.equals("E401")) {
                    LOG.error("JMS broker is DISCONNECTED.");
                    this.isAlive.set(false);
                } else if (eventCode.equals("E301")) {
                    LOG.info("CONNECTED successfully to JMS broker.");
                    this.isAlive.set(true);
                }
            }
            LOG.info("Received JMS notification event. EventCode={}, EventMessage={}. JMS Connection={}", new Object[]{eventCode, eventMessage, this.isAlive() ? "Connected" : "Disconnected"});
        });
        connection.start();
        Session session = connection.createSession(true, 0);
        String queueName = this.getInJmsDestination().getQueueName();
        Queue queue = session.createQueue(queueName);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        consumer.setMessageListener(message -> {
            LOG.info("Processing JMS message {}, queuename:{}", (Object)message.toString(), (Object)queueName);
            this.onMessageArrive(session, message);
        });
        this.isAlive.set(true);
    }

    private T beforeReadingMessage(Message message) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        TextMessage textMessage = (TextMessage)message;
        JmsMessage jmsMessage = (JmsMessage)objectMapper.readValue(textMessage.getText(), JmsMessage.class);
        if (!DigestUtils.sha512Hex((String)jmsMessage.getMessage()).equals(jmsMessage.getFingerPrint())) {
            throw new JMSException("Invalid fingerprint of the jms message. Please make sure the jms message is not altered.");
        }
        return (T)((Serializable)objectMapper.readValue(jmsMessage.getMessage(), Generics.getTypeParameter(this.getClass())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onMessageArrive(Session session, Message message) {
        try {
            T jmsObject = this.beforeReadingMessage(message);
            this.afterReadingMessage(jmsObject);
            this.consecutiveErrors.set(0L);
        }
        catch (Exception e) {
            this.sendToErrorQueue(session, message, e);
            LOG.warn("Ignored: Exception while processing message: " + message.toString(), (Throwable)e);
            LOG.warn("Consecutive error count = {}, max = {}.", (Object)this.consecutiveErrors.incrementAndGet(), (Object)5);
            if (this.consecutiveErrors.get() % 5L == 0L) {
                this.notifyMaxConsecutiveErrorsReached(message, e);
            }
        }
        finally {
            try {
                session.commit();
            }
            catch (JMSException ignore) {
                LOG.warn("Exception occured while commiting session. Message Details:" + message.toString(), (Throwable)ignore);
                AbstractJmsQueuePoller.rollbackLogException(session);
            }
        }
    }

    public boolean isAlive() {
        return this.isAlive.get();
    }

    public void shutdown() {
        this.isAlive.set(false);
    }

    private void notifyMaxConsecutiveErrorsReached(Message message, Exception e) {
        LOG.info("Attempting to send mail.");
        StringBuilder sb = new StringBuilder();
        sb.append("Exception occured for the given JMS message. Please investigate.");
        sb.append(message.toString());
        sb.append(" Exception is: ");
        sb.append(ExceptionUtils.getStackTrace((Throwable)e));
        this.errorNotifier.notifyAlert("Max consecutive errors reached: " + this.consecutiveErrors.get(), sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToErrorQueue(Session session, Message message, Exception e) {
        LOG.info("Attempting to send mail before placing message on error queue.");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Could not process a jms message from queue:" + this.getInJmsDestination().toString());
            sb.append(" Exception is: ");
            sb.append(e.toString());
            sb.append("\nThe message will be moved to the error queue.\n");
            sb.append("JMS Message:").append(message.toString());
            sb.append("\n\n");
            sb.append("Stack trace is:\n");
            sb.append(ExceptionUtils.getStackTrace((Throwable)e));
            String emailMessage = sb.toString();
            this.errorNotifier.notifyAlert("Message placed on error queue.", emailMessage);
        }
        finally {
            this.sendToErrorQueue(session, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToErrorQueue(Session session, Message message) {
        String errorQueue = this.getErrorQueueJmsDestination().getQueueName();
        Queue queue = null;
        MessageProducer producer = null;
        try {
            queue = session.createQueue(errorQueue);
            producer = session.createProducer((Destination)queue);
            LOG.info("Sending JMS message to error queue {}. Message: {}", (Object)errorQueue, (Object)message.toString());
            producer.send(message);
            LOG.info("JMS message id: '{}' successfully sent to error queue {}.", (Object)message.getJMSMessageID(), (Object)errorQueue);
        }
        catch (JMSException e) {
            LOG.warn("Exception while sending message to error queue.", (Throwable)e);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                    LOG.info("JMS producer closed.");
                }
                catch (JMSException e) {
                    LOG.warn("Exception while closing producer.", (Throwable)e);
                }
            }
        }
    }

    private static void rollbackLogException(Session session) {
        try {
            LOG.info("Rolling back session.");
            session.rollback();
        }
        catch (JMSException e) {
            LOG.warn("Exception while rolling back session.", (Throwable)e);
        }
    }
}

