/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.sms;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.lwapp.notification.jms.JmsDestination;
import org.lwapp.notification.jms.incoming.AbstractJmsQueuePoller;
import org.lwapp.notification.sms.Sms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SmsNotificationManager
extends AbstractJmsQueuePoller<Sms> {
    private static final Logger LOG = LoggerFactory.getLogger(SmsNotificationManager.class);
    @Inject
    private CommonNotificationsApplicationConfig configurationClient;

    @Override
    protected JmsDestination getInJmsDestination() {
        return this.configurationClient.getSmsIncomingJmsQueue();
    }

    @Override
    protected JmsDestination getErrorQueueJmsDestination() {
        return this.configurationClient.getSmsErrorJmsQueue();
    }

    @Override
    protected void afterReadingMessage(Sms sms) throws Exception {
        this.sendMessageNow(sms);
    }

    private void sendMessageNow(Sms sms) {
        for (String to : sms.getToNumbers()) {
            LOG.info("Sending SMS to :{}", (Object)to);
        }
    }
}

