/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.twitter;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.lwapp.notification.config.CommonNotificationsApplicationConfig;
import org.lwapp.notification.jms.JmsDestination;
import org.lwapp.notification.jms.incoming.AbstractJmsQueuePoller;
import org.lwapp.notification.twitter.Tweet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TwitterNotificationManager
extends AbstractJmsQueuePoller<Tweet> {
    private static final Logger LOG = LoggerFactory.getLogger(TwitterNotificationManager.class);
    @Inject
    private CommonNotificationsApplicationConfig configurationClient;

    @Override
    protected JmsDestination getInJmsDestination() {
        return this.configurationClient.getTwitterIncomingJmsQueue();
    }

    @Override
    protected JmsDestination getErrorQueueJmsDestination() {
        return this.configurationClient.getTwitterErrorJmsQueue();
    }

    @Override
    protected void afterReadingMessage(Tweet tweetRequest) throws Exception {
        this.tweet(tweetRequest.getTo(), tweetRequest.getMessage());
    }

    private void tweet(String to, String message) {
        LOG.info("Sending twitter:\n@{},\t{}", (Object)to, (Object)message);
    }
}

