/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.notification.utils;

import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class Generics {
    private Generics() {
    }

    public static Class<?> getTypeParameter(Class<?> klass) {
        return Generics.getTypeParameter(klass, Object.class);
    }

    public static <T> Class<T> getTypeParameter(Class<?> klass, Class<? super T> bound) {
        Type t = (Type)Preconditions.checkNotNull(klass);
        while (t instanceof Class) {
            t = ((Class)t).getGenericSuperclass();
        }
        if (t instanceof ParameterizedType) {
            for (Type param : ((ParameterizedType)t).getActualTypeArguments()) {
                if (param instanceof Class) {
                    Class<? super T> cls = Generics.determineClass(bound, param);
                    if (cls == null) continue;
                    return cls;
                }
                if (!(param instanceof TypeVariable)) continue;
                for (Type paramBound : ((TypeVariable)param).getBounds()) {
                    Class<? super T> cls;
                    if (!(paramBound instanceof Class) || (cls = Generics.determineClass(bound, paramBound)) == null) continue;
                    return cls;
                }
            }
        }
        throw new IllegalStateException("Cannot figure out type parameterization for " + klass.getName());
    }

    private static <T> Class<T> determineClass(Class<? super T> bound, Type candidate) {
        Class cls;
        if (candidate instanceof Class && bound.isAssignableFrom(cls = (Class)candidate)) {
            return cls;
        }
        return null;
    }
}

