package org.lwapp.security.cli;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.lwapp.commons.cli.AbstractCommand;
import org.lwapp.commons.cli.Terminal;
import org.lwapp.hibernate.persistence.common.UniqueNumberGenerator;
import org.lwapp.hibernate.persistence.util.TransactionHelper;
import org.lwapp.security.db.dao.AuthorizedAppsDao;
import org.lwapp.security.db.dao.AuthorizedOwnerDao;
import org.lwapp.security.db.entity.AuthorizedApps;
import org.lwapp.security.db.entity.AuthorizedOwner;

public class AuthorizationCommand extends AbstractCommand {

	public AuthorizationCommand() {
		super("authorize");
	}

	private final AuthorizedOwnerDao authorizedOwnerDao = new AuthorizedOwnerDao();
	private final AuthorizedAppsDao authorizedAppsDao = new AuthorizedAppsDao();
	private final UniqueNumberGenerator uniqueNumberGenerator = new UniqueNumberGenerator();

	@Override
	public void printDescription(final Terminal term) {
		term.println("Create new owner and add new applications.");
	}

	@Override
	public void printUsage(final Terminal term) {
		term.println(getCommandName() + "\t'-createOwner <ownerName> <uniqueOwnerId>' \n\t'-createApp <uniqueOwnerId> <applicationName>'");
	}

	@Override
	public void execute(final Terminal term, final String aArguments) {

		try {
			final String response = TransactionHelper.executeInTransaction(() -> {
				if (StringUtils.isBlank(aArguments)) {
					throw new IllegalArgumentException("Invalid command.");
				}

				final String[] args = aArguments.trim().split(" ");

				if (args.length < 1) {
					throw new IllegalArgumentException("Invalid command.");
				}

				if ("-createOwner".equalsIgnoreCase(args[0])) {
					if (args.length != 3) {
						throw new IllegalArgumentException("Invalid arguments.");
					}
					final String ownerName = args[1];
					final AuthorizedOwner authOwner = new AuthorizedOwner();
					final String ownerId = args[2];
					authOwner.setOwnerName(ownerName);
					authOwner.setOwnerId(ownerId);
					authorizedOwnerDao.persist(authOwner);
					return String.format("\n\nOwner is created succussfully with \n\nownerName:%s \n\nownerId:%s", ownerName, ownerId);

				} else if ("-createApp".equalsIgnoreCase(args[0])) {
					if (args.length != 3) {
						throw new IllegalArgumentException("Invalid arguments.");
					}
					final String uniqueOwnerId = args[1];
					final AuthorizedOwner authOwner = authorizedOwnerDao.findByUniqueOwnerId(uniqueOwnerId);

					final String appName = args[2];
					final AuthorizedApps authApp = new AuthorizedApps();
					authApp.setApiKey(uniqueNumberGenerator.generateUniqueApiKey());
					authApp.setApiSecret(uniqueNumberGenerator.generateUniqueApiSecret());
					authApp.setApplicationName(appName);
					authApp.setAuthorizedOwner(authOwner);
					authorizedAppsDao.persist(authApp);
					return String.format("\n\nApp is created succussfully with authApp \n\nkey:%s \n\nsecret:%s \nownerId:%s", authApp.getApiKey(), authApp.getApiSecret(),
							authOwner.getOwnerId());

				} else {
					throw new IllegalArgumentException("Invalid command.");
				}
			});

			term.println(response);
		} catch (final Exception e) {
			term.println(ExceptionUtils.getStackTrace(e));
			e.printStackTrace();
			printUsage(term);
		}
	}

}
