package org.lwapp.security.db.entity;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.lwapp.hibernate.persistence.common.BaseEntity;

@Entity(name = "Application_AuthorizedApps")
@Table(uniqueConstraints = { @UniqueConstraint(columnNames = { "applicationName", "FK_AuthorizedOwnerId" }) })

public class AuthorizedApps extends BaseEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	@Column(unique = true)
	private String apiKey;
	@Column(nullable = false)
	private String apiSecret;
	@Column(nullable = false)
	private String applicationName;
	@OneToOne(cascade = { CascadeType.ALL })
	@JoinColumn(name = "FK_AuthorizedOwnerId", nullable = false)
	private AuthorizedOwner authorizedOwner;

	public String getApiKey() {
		return apiKey;
	}

	public void setApiKey(final String apiKey) {
		this.apiKey = apiKey;
	}

	public String getApiSecret() {
		return apiSecret;
	}

	public void setApiSecret(final String apiSecret) {
		this.apiSecret = apiSecret;
	}

	public String getApplicationName() {
		return applicationName;
	}

	public void setApplicationName(final String applicationName) {
		this.applicationName = applicationName;
	}

	public AuthorizedOwner getAuthorizedOwner() {
		return authorizedOwner;
	}

	public void setAuthorizedOwner(final AuthorizedOwner authorizedOwner) {
		this.authorizedOwner = authorizedOwner;
	}

}
