package org.lwapp.security.db.dao;

import org.apache.commons.lang3.Validate;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;
import org.lwapp.hibernate.persistence.common.BaseEntityDao;
import org.lwapp.security.db.entity.AuthorizedOwner;

public class AuthorizedOwnerDao extends BaseEntityDao<AuthorizedOwner> {

	public AuthorizedOwner findByUniqueOwnerId(final String uniqueOwnerId) {
		Validate.notBlank(uniqueOwnerId, "Please provide uniqueOwnerId");
		final Criteria criteria = criteria()//
				.add(Restrictions.eq("ownerId", uniqueOwnerId));

		final AuthorizedOwner authorizedOwner = uniqueResult(criteria);
		Validate.notNull(authorizedOwner, "Un-authorized owner");

		return authorizedOwner;
	}

}