package org.lwapp.security.ws.provider;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.lwapp.commons.ErrorResponse;
import org.lwapp.commons.exception.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class UnAuthorizedExceptionMapper implements ExceptionMapper<UnauthorizedException> {
	private static final Logger LOG = LoggerFactory.getLogger(UnAuthorizedExceptionMapper.class);

	@Override
	public Response toResponse(final UnauthorizedException ex) {
		LOG.error("UnauthorizedException occured.", ex);
		return Response.status(Response.Status.UNAUTHORIZED).entity(new ErrorResponse(ex.getMessage())).build();
	}

}
