package org.lwapp.security.ws.rest.domain;

import java.io.Serializable;

public class ApplicationOwnerRegistrationResponse implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String apiKey;
	private String apiSecret;
	private String uniqueOwnerId;
	private String applicationName;

	public String getUniqueOwnerId() {
		return uniqueOwnerId;
	}

	public void setUniqueOwnerId(final String uniqueOwnerId) {
		this.uniqueOwnerId = uniqueOwnerId;
	}

	public String getApplicationName() {
		return applicationName;
	}

	public void setApplicationName(final String applicationName) {
		this.applicationName = applicationName;
	}

	public String getApiKey() {
		return apiKey;
	}

	public void setApiKey(final String apiKey) {
		this.apiKey = apiKey;
	}

	public String getApiSecret() {
		return apiSecret;
	}

	public void setApiSecret(final String apiSecret) {
		this.apiSecret = apiSecret;
	}

	public static class Builder {
		private String apiKey;
		private String apiSecret;
		private String uniqueOwnerId;
		private String applicationName;

		public Builder apiKey(final String apiKey) {
			this.apiKey = apiKey;
			return this;
		}

		public Builder apiSecret(final String apiSecret) {
			this.apiSecret = apiSecret;
			return this;
		}

		public Builder uniqueOwnerId(final String uniqueOwnerId) {
			this.uniqueOwnerId = uniqueOwnerId;
			return this;
		}

		public Builder applicationName(final String applicationName) {
			this.applicationName = applicationName;
			return this;
		}

		public ApplicationOwnerRegistrationResponse build() {
			final ApplicationOwnerRegistrationResponse applicationOwnerRegistrationResponse = new ApplicationOwnerRegistrationResponse();
			applicationOwnerRegistrationResponse.apiKey = apiKey;
			applicationOwnerRegistrationResponse.apiSecret = apiSecret;
			applicationOwnerRegistrationResponse.uniqueOwnerId = uniqueOwnerId;
			applicationOwnerRegistrationResponse.applicationName = applicationName;
			return applicationOwnerRegistrationResponse;
		}
	}
}
