/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.security.service;

import java.io.IOException;
import java.util.Base64;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.apache.commons.lang3.Validate;
import org.lwapp.security.db.dao.AuthorizedAppsDao;

public class AuthorizationService {
    @Inject
    private AuthorizedAppsDao authorizedAppsDao;

    public boolean authenticate(String authCredentials, String ownerId, String applicationName) throws IOException {
        Validate.notBlank((CharSequence)authCredentials, (String)"Please provide basic authentication in header.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ownerId, (String)"ownerId is mandatory.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"ApplicationName is mandatory.", (Object[])new Object[0]);
        String encodedApiKeyAndSecret = authCredentials.replaceFirst("Basic ", "");
        byte[] decodedBytes = Base64.getDecoder().decode(encodedApiKeyAndSecret);
        String apiKeyAndSecret = new String(decodedBytes, "UTF-8");
        StringTokenizer tokenizer = new StringTokenizer(apiKeyAndSecret, ":");
        String apiKey = tokenizer.nextToken();
        String apiSecret = tokenizer.nextToken();
        return this.authorizedAppsDao.isAuthorizedApp(apiKey, apiSecret, applicationName, ownerId);
    }
}

