/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.security.ws.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Validate;
import org.lwapp.commons.exception.UnauthorizedException;
import org.lwapp.hibernate.interceptor.UnitOfWork;
import org.lwapp.hibernate.interceptor.UnitOfWorkInterceptor;
import org.lwapp.security.service.AuthorizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Interceptors(value={UnitOfWorkInterceptor.class})
public class SecurityFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityFilter.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String APPLICATION_OWNER_ID = "ApplicationOwnerId";
    public static final String APPLICATION_NAME = "ApplicationName";
    @Inject
    private AuthorizationService authenticationService;

    @UnitOfWork
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (Boolean.valueOf(requestContext.getHeaderString("Internal")).booleanValue()) {
            return;
        }
        String applicationOwnerId = requestContext.getHeaderString(APPLICATION_OWNER_ID);
        Validate.notBlank((CharSequence)applicationOwnerId, (String)"Please provide ApplicationOwner in header.", (Object[])new Object[0]);
        String authCredentials = requestContext.getHeaderString(AUTHORIZATION_HEADER);
        Validate.notBlank((CharSequence)authCredentials, (String)"Please provide basic authentication in header.", (Object[])new Object[0]);
        String applicationName = requestContext.getHeaderString(APPLICATION_NAME);
        Validate.notBlank((CharSequence)applicationName, (String)"Please provide ApplicationName in header.", (Object[])new Object[0]);
        boolean authenticationStatus = this.authenticationService.authenticate(authCredentials, applicationOwnerId, applicationName);
        if (BooleanUtils.isFalse((Boolean)authenticationStatus)) {
            throw new UnauthorizedException("Un-authorized application client. Make sure you have used correctly 'apiKey' and 'apiSecret' shall be part of BasicAuthentication. Please check headers for 'applicationName' and 'applicationOwnerId' entries aswell.");
        }
        LOG.info("Method:{}, applicationOwnerId:{}, applicationName:{}", new Object[]{requestContext.getMethod(), applicationOwnerId, applicationName});
    }
}

