/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.security.ws.rest;

import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.lwapp.commons.exception.ApplicationException;
import org.lwapp.hibernate.interceptor.UnitOfWork;
import org.lwapp.hibernate.interceptor.UnitOfWorkInterceptor;
import org.lwapp.hibernate.persistence.common.AbstractEntity;
import org.lwapp.hibernate.persistence.common.UniqueNumberGenerator;
import org.lwapp.security.db.dao.AuthorizedAppsDao;
import org.lwapp.security.db.dao.AuthorizedOwnerDao;
import org.lwapp.security.db.entity.AuthorizedApps;
import org.lwapp.security.db.entity.AuthorizedOwner;
import org.lwapp.security.ws.rest.domain.ApplicationOwnerRegistrationRequest;
import org.lwapp.security.ws.rest.domain.ApplicationOwnerRegistrationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="admin")
@Interceptors(value={UnitOfWorkInterceptor.class})
public class ApplicationAuthorizationResource {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationAuthorizationResource.class);
    @Inject
    private AuthorizedOwnerDao authorizedOwnerDao;
    @Inject
    private AuthorizedAppsDao authorizedAppsDao;
    @Inject
    private UniqueNumberGenerator uniqueNumberGenerator;

    @POST
    @Path(value="application/generateapikeys")
    @UnitOfWork
    public Response generateApiKeys(ApplicationOwnerRegistrationRequest request) {
        AuthorizedApps authApp;
        String uniqueOwnerId = request.getUniqueOwnerId();
        AuthorizedOwner authOwner = this.authorizedOwnerDao.findByUniqueOwnerId(uniqueOwnerId);
        if (authOwner == null) {
            authOwner = new AuthorizedOwner();
            authOwner.setOwnerName(request.getOwnerName());
            authOwner.setOwnerId(uniqueOwnerId);
            this.authorizedOwnerDao.persist(authOwner);
        }
        if ((authApp = this.authorizedAppsDao.findByApplication(request.getApplicationName(), uniqueOwnerId)) == null) {
            authApp = new AuthorizedApps();
            authApp.setApiKey(this.uniqueNumberGenerator.generateUniqueApiKey());
            authApp.setApiSecret(this.uniqueNumberGenerator.generateUniqueApiSecret());
            authApp.setApplicationName(request.getApplicationName());
            authApp.setAuthorizedOwner(authOwner);
            this.authorizedAppsDao.persist(authApp);
        }
        ApplicationOwnerRegistrationResponse response = new ApplicationOwnerRegistrationResponse.Builder().apiKey(authApp.getApiKey()).apiSecret(authApp.getApiSecret()).applicationName(request.getApplicationName()).uniqueOwnerId(request.getUniqueOwnerId()).build();
        LOG.info("Application owner is created succussfully with authApp \n\napiKey:{} \n\napiSecret:{} \nownerId:{} \napplicationName:{}", new Object[]{authApp.getApiKey(), authApp.getApiSecret(), request.getUniqueOwnerId(), request.getApplicationName()});
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="application/regenerateapikeys/")
    @UnitOfWork
    public Response reGenerateApiKeys(ApplicationOwnerRegistrationRequest request) {
        String uniqueOwnerId = request.getUniqueOwnerId();
        AuthorizedOwner authOwner = this.authorizedOwnerDao.findByUniqueOwnerId(uniqueOwnerId);
        if (authOwner == null) {
            throw new ApplicationException("No application owner found with the given ownerId.");
        }
        AuthorizedApps authApp = this.authorizedAppsDao.findByApplication(request.getApplicationName(), uniqueOwnerId);
        String apiKey = this.uniqueNumberGenerator.generateUniqueApiKey();
        String apiSecret = this.uniqueNumberGenerator.generateUniqueApiSecret();
        if (authApp == null) {
            authApp = new AuthorizedApps();
            authApp.setApiKey(apiKey);
            authApp.setApiSecret(apiSecret);
            authApp.setApplicationName(request.getApplicationName());
            authApp.setAuthorizedOwner(authOwner);
            this.authorizedAppsDao.persist(authApp);
        } else {
            authApp.setApiKey(apiKey);
            authApp.setApiSecret(apiSecret);
            this.authorizedAppsDao.update((AbstractEntity)authApp);
        }
        ApplicationOwnerRegistrationResponse response = new ApplicationOwnerRegistrationResponse.Builder().apiKey(authApp.getApiKey()).apiSecret(authApp.getApiSecret()).applicationName(request.getApplicationName()).uniqueOwnerId(request.getUniqueOwnerId()).build();
        LOG.info("Application owner api keys are recreated succussfully with authApp \n\napiKey:{} \n\napiSecret:{} \nownerId:{} \napplicationName:{}", new Object[]{authApp.getApiKey(), authApp.getApiSecret(), request.getUniqueOwnerId(), request.getApplicationName()});
        return Response.ok((Object)response).build();
    }
}

