package org.lwapp.security.service;

import java.io.IOException;
import java.util.Base64;
import java.util.StringTokenizer;

import javax.inject.Inject;
import javax.interceptor.Interceptors;

import org.apache.commons.lang3.Validate;
import org.lwapp.hibernate.interceptor.UnitOfWork;
import org.lwapp.hibernate.interceptor.UnitOfWorkInterceptor;
import org.lwapp.security.db.dao.AuthorizedAppsDao;

@Interceptors({ UnitOfWorkInterceptor.class })
public class AuthorizationService {

	@Inject
	private AuthorizedAppsDao authorizedAppsDao;

	@UnitOfWork
	public boolean authenticate(final String authCredentials, final String ownerId, final String applicationName) throws IOException {

		Validate.notBlank(authCredentials, "Please provide basic authentication in header.");
		Validate.notBlank(ownerId, "ownerId is mandatory.");
		Validate.notBlank(applicationName, "ApplicationName is mandatory.");

		// header value format will be "Basic encoded string" for Basic
		// authentication. Example "Basic YWRtaW46YWRtaW4=" for admin:admin
		final String encodedApiKeyAndSecret = authCredentials.replaceFirst("Basic" + " ", "");
		final byte[] decodedBytes = Base64.getDecoder().decode(encodedApiKeyAndSecret);
		final String apiKeyAndSecret = new String(decodedBytes, "UTF-8");
		final StringTokenizer tokenizer = new StringTokenizer(apiKeyAndSecret, ":");
		final String apiKey = tokenizer.nextToken();
		final String apiSecret = tokenizer.nextToken();

		return authorizedAppsDao.isAuthorizedApp(apiKey, apiSecret, applicationName, ownerId);
	}
}