package org.lwapp.security.db.dao;

import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;
import org.lwapp.hibernate.persistence.common.BaseEntityDao;
import org.lwapp.security.db.entity.AuthorizedApps;

public class AuthorizedAppsDao extends BaseEntityDao<AuthorizedApps> {

	public boolean isAuthorizedApp(final String apiKey, final String apiSecret, final String applicationName, final String ownerId) {
		final Criteria criteria = criteria()//
				.add(Restrictions.eq("apiKey", apiKey))//
				.add(Restrictions.eq("apiSecret", apiSecret))//
				.add(Restrictions.eq("applicationName", applicationName))//
				.createAlias("authorizedOwner", "ao")//
				.add(Restrictions.eq("ao.ownerId", ownerId));

		return uniqueResult(criteria) != null;
	}

	public AuthorizedApps findByApplication(final String applicationName, final String uniqueOwnerId) {
		final Criteria criteria = criteria()//
				.add(Restrictions.eq("applicationName", applicationName))//
				.createAlias("authorizedOwner", "ao")//
				.add(Restrictions.eq("ao.ownerId", uniqueOwnerId));

		return uniqueResult(criteria);
	}

}